// Common Header
#pragma rtGlobals=3
#pragma rtFunctionErrors=1
#pragma IgorVersion=9
#pragma TextEncoding="UTF-8"
#pragma hide = 1

// Procedure Loader Hide

// Module Name
#pragma ModuleName=SpXZgRMain

// Specific Parameters
// main panel name and initial location
StrConstant k_SpXZgRMainPanelName="SpXZeigRPanel"
Constant k_SpXZgRMainTop=20
Constant k_SpXZgRMainTop_Mac=70
// main panel width and height
Constant k_SpXZgRpwidth=270
Constant k_SpXZgRpheight=210
Constant k_SpXZgRptrim=15

// @brief structure for control panel values
Structure SpXZgR_DisplayStruct
	string folder
	string files
	string filex
	variable assp
	string multitrace
EndStructure

// @brief get the panel values
// @return implicit structure with panel values
Function SpXZgR_getPanelValues(STRUCT SpXZgR_DisplayStruct &sds)

	ControlInfo/W=$k_SpXZgRMainPanelName flist_tb1
	sds.folder = s_value
	ControlInfo/W=$k_SpXZgRMainPanelName spectrum_tb1
	sds.files = s_value
	ControlInfo/W=$k_SpXZgRMainPanelName spectrumx_tb1
	sds.filex = s_value
	ControlInfo/W=$k_SpXZgRMainPanelName xavoidself_tb1
	sds.assp = v_value
	ControlInfo/W=$k_SpXZgRMainPanelName multitrace_tb1
	sds.multitrace = s_value
end

// @brief create the main panel
Static Function create_SpXZgRMainPanel()

	variable py = 10
	variable dfGMn = 1
	variable dfSTn = 1
	variable dfTSn = 1
	
	// Panel
	
	NewPanel/K=1/N=$k_SpXZgRMainPanelName/W=(0,0,k_SpXZgRpwidth,k_SpXZgRpheight) as "SpXZeigR"
	if (cmpstr(IgorInfo(2),"Windows")==0)
		MoveWindow/W=$k_SpXZgRMainPanelName k_SpXZgRMainTop, k_SpXZgRMainTop, -1, -1
	else
		MoveWindow/W=$k_SpXZgRMainPanelName k_SpXZgRMainTop, k_SpXZgRMainTop_Mac, -1, -1
	endif
	
	// Folder List

	PopupMenu flist_tb1,pos={k_SpXZgRpTrim,py},size={122,20},title="Folder", fSize=12, proc=cpu_SpXZgRDisplay
	PopupMenu flist_tb1, mode=1, value=#"SpXZgRMain#f_FolderList()", help={"Choose the data folder holding the waves to plot."}

	// info, help, settings
	
	SpXZgR_addExtraButtons(py)

	// File List

	py += 35

	PopupMenu spectrum_tb1,pos={k_SpXZgRpTrim,py},size={87,20},title="Show",fSize=12, help={"Define the wave(s) to display in the plot."}
	PopupMenu spectrum_tb1,mode=1,value=#"SpXZgRMain#f_SpectraList(0)", proc=cpu_SpXZgRDisplay
	
	py += 3	// 68

	// Wildcard Input
	
	py += 22	// 90

	SetVariable wildcard_tb1, pos={k_SpXZgRpTrim,py},size={185,17},title="Wildcard",fSize=12
	SetVariable wildcard_tb1, value=_STR:"*", proc=SpXZgRMain#SpXZgR_ValidateWildCard, disable=1
	SetVariable wildcard_tb1, help={"Input a wildcard string to narrow the selection on what is graphed."}
	
	CheckBox xnegwc_tb1, pos={k_SpXZgRpwidth-40,py}, size={60,20}, title="(-)", value=0, disable=1, proc=ccb_SpXZgRDisplay
	CheckBox xnegwc_tb1, help={"Set this to negate your choice, i.e.\rto display all but the wildcard selection."}

	// x wave
	
	py += 30
	
	PopupMenu spectrumx_tb1,pos={k_SpXZgRpTrim,py},size={157,20},title="X Wave",fSize=12, proc=cpu_SpXZgRDisplay
	PopupMenu spectrumx_tb1,mode=1,value=#"SpXZgRMain#f_SpectraXList()", help={"Define the x wave."}

	py += 25
	
	CheckBox xavoidself_tb1,pos={k_SpXZgRpTrim,py},size={60,20},title="avoid self-self plot",fSize=10
	CheckBox xavoidself_tb1,value=1,disable=0, help={"Avoid plotting the x wave as y wave vs x wave."}
			
	// Multitrace Control
	
	py += 25		// 120

	PopupMenu multitrace_tb1,pos={k_SpXZgRpTrim,py},size={157,20},title="Multi-Trace",fSize=12
	PopupMenu multitrace_tb1,mode=1,value=#"SpXZgRMain#f_MultiTraceMenu()", help={"Define how to show more than one spectrum."}
	
	// Display Button
	
	py += 25
	
	Button displayspectra_tb1, pos={k_SpXZgRpTrim,py}, size={90,20}, title="Display", fSize=12
	Button displayspectra_tb1, proc=cbc_SpXZgRDisplay, help={"Display spectra."}

	SpXZgR_changeDisplayFromFolder()

	SetWindow $k_SpXZgRMainPanelName, userData(nGraphs)="0"
	set_SpXZgRHook("hf_SpXZgRMainPanel",winnm=k_SpXZgRMainPanelName)

	return 0
end

// @brief add buttons on panel
Static Function SpXZgR_addExtraButtons(variable py)
	Button btnInfo_tb0, pos={k_SpXZgRpwidth-60,py}, size={15,15}, title="", Picture=ProcGlobal#SpXZgR_pInfo
	Button btnInfo_tb0, proc=cbc_SpXZgRMain, help={"Show Info"}
	Button btnHelp_tb0, pos={k_SpXZgRpwidth-40,py}, size={15,15}, title="", Picture=ProcGlobal#SpXZgR_pHelp, labelBack=0
	Button btnHelp_tb0, proc=cbc_SpXZgRMain, help={"Click for help"}, focusRing=0
//	Button btnSettings_tb0, pos={k_SpXZgRpwidth-20,py}, size={15,15}, title="", Picture=SpXZgR_pCog, labelBack=0
//	Button btnSettings_tb0, proc=SpXZgR_doButton, help={"Change Settings"}, focusRing=0, disable=2
	return 0
end

// @brief respond to button clicks
Function cbc_SpXZgRMain(STRUCT WMButtonAction &ba) : ButtonControl

	if (ba.eventCode == 2)
		strswitch(ba.ctrlName)
			case "btnInfo_tb0":
				SpXZgR_InfoMenu()
				break
			case "btnHelp_tb0":
				SpXZgR_HelpMenu()
				break
			case "btnSettings_tb0":
				break
			default:
				break
		endswitch
	endif
	return 0
end

// @brief button control
Function cbc_SpXZgRDisplay(STRUCT WMButtonAction &ba) : ButtonControl

	if (ba.eventCode == 2)
		SpXZgR_DisplaySpectra()
		SpXZgRLayout#attach_SpXZeigRPanel()
	endif
	return 0
end

// @brief checkbox control
Function ccb_SpXZgRDisplay(STRUCT WMCheckboxAction &cba) : CheckBoxControl
	
	switch( cba.eventCode )
		case 2: // mouse up
			SpXZgR_changeDisplaySpectra(2)
			break
		default:
			break
	endswitch

	return 0
End

// @brief popmenu control
Function cpu_SpXZgRDisplay(STRUCT WMPopupAction &pa) : PopupMenuControl

	switch( pa.eventCode )
		case 2:
			if (SpXZgR_PopHasChanged(pa))
				strswitch(pa.ctrlName)
					case "flist_tb1":		// folder
						SpXZgR_changeDisplayFromFolder()
						break
					case "spectrum_tb1":		// spectrum choices
						SpXZgR_changeDisplaySpectra(pa.popNum)
						break
					case "spectrumx_tb1":
						SpXZgR_changeDisplayxSpectra(pa.popNum)
						break
					default:
						break
				endswitch
			endif
			break
		default:
			break
	endswitch
	return 0
end

// @brief change panel controls when folder is changed
Function SpXZgR_changeDisplayFromFolder()

	// spectra and graphs
	variable nS = ItemsInList(f_SpectraList(1))
	variable nG = ItemsInList(WinList("*",";","WIN:1;VISIBLE:1"))

	variable mode, disable
	string tstr = "Traces (" + num2str(ns) + ")"
	// make changes
	switch(ns)	
		case 0:
			mode = 1; disable = 2
			PopupMenu spectrumx_tb1, win=$k_SpXZgRMainPanelName, disable=2
			CheckBox xavoidself_tb1, win=$k_SpXZgRMainPanelName, disable=1
			PopupMenu multitrace_tb1, win=$k_SpXZgRMainPanelName, disable=2, title=tstr
			SetVariable wildcard_tb1, win=$k_SpXZgRMainPanelName, disable=1
			CheckBox xnegwc_tb1, win=$k_SpXZgRMainPanelName, disable=1
			break
		case 1:
			mode = 4; disable = 0
			PopupMenu spectrumx_tb1, win=$k_SpXZgRMainPanelName, disable=0
			PopupMenu multitrace_tb1, win=$k_SpXZgRMainPanelName, disable=0, title=tstr
			SetVariable wildcard_tb1, win=$k_SpXZgRMainPanelName, disable=1
			CheckBox xnegwc_tb1, win=$k_SpXZgRMainPanelName, disable=1
			break
		default:	// more than one spectrum to display
			mode = 1; disable = 0
			PopupMenu spectrumx_tb1, win=$k_SpXZgRMainPanelName, disable=0
			PopupMenu multitrace_tb1, win=$k_SpXZgRMainPanelName, disable=0, title=tstr
			SetVariable wildcard_tb1, win=$k_SpXZgRMainPanelName, disable=1
			CheckBox xnegwc_tb1, win=$k_SpXZgRMainPanelName, disable=1
			break
	endswitch
	// force an update on controls
	PopupMenu spectrum_tb1, win=$k_SpXZgRMainPanelName, mode=mode, disable=disable
	if (nG == 0)
		PopupMenu multitrace_tb1, win=$k_SpXZgRMainPanelName, mode=1
	endif
	ControlUpdate/W=$k_SpXZgRMainPanelName multitrace_tb1
	if (ns == 0)
		PopupMenu spectrumx_tb1, win=$k_SpXZgRMainPanelName, mode=1, disable=2
		CheckBox xavoidself_tb1, win=$k_SpXZgRMainPanelName, value=1, disable=2
	else
		PopupMenu spectrumx_tb1, win=$k_SpXZgRMainPanelName, mode=1, disable=0
		CheckBox xavoidself_tb1, win=$k_SpXZgRMainPanelName, value=1, disable=2
	endif
	Button displaySpectra_tb1, win=$k_SpXZgRMainPanelName, disable=(2*(ns==0))
	return 0
end

// @brief updates panel when display spectra change
// @return number of spectra chosen
Function SpXZgR_changeDisplaySpectra(variable how)
		
	variable ns 
	ControlInfo/W=$k_SpXZgRMainPanelName spectrum_tb1
	ns = (v_value > 3) ? 1 : ItemsInList(f_SpectraList(1))
	variable disable = (ns > 0) ? 0 : 2
	string tstr = "Traces (" + num2str(ns) + ")"
	switch(how)
		case 1:		// all
			PopupMenu multitrace_tb1, win=$k_SpXZgRMainPanelName, disable=disable, title=tstr
			SetVariable wildcard_tb1, win=$k_SpXZgRMainPanelName, disable=1
			CheckBox xnegwc_tb1, win=$k_SpXZgRMainPanelName, disable=1
			break
		case 2:		// match wild card
			PopupMenu multitrace_tb1, win=$k_SpXZgRMainPanelName, disable=disable, title=tstr
			SetVariable wildcard_tb1, win=$k_SpXZgRMainPanelName, disable=0
			CheckBox xnegwc_tb1, win=$k_SpXZgRMainPanelName, disable=0
			break
		default:		// only one or specific
			PopupMenu multitrace_tb1, win=$k_SpXZgRMainPanelName, disable=disable, title=tstr
			SetVariable wildcard_tb1, win=$k_SpXZgRMainPanelName, disable=1
			CheckBox xnegwc_tb1, win=$k_SpXZgRMainPanelName, disable=1
			break
	endswitch
	Button displayspectra_tb1, win=$k_SpXZgRMainPanelName, disable=disable
	PopupMenu spectrumx_tb1, win=$k_SpXZgRMainPanelName, disable=disable
	return 0
end

// @brief change the control for x spectrum
Function SpXZgR_changeDisplayxSpectra(variable how)	

	CheckBox xavoidself_tb1, win=$k_SpXZgRMainPanelName, disable=(2*(how == 1))
	return 0
end

// @brief validate wild card
Function SpXZgR_validateWildCard(STRUCT WMSetVariableAction &sv) : SetVariableControl
	
	SVAR/Z dwc = root:Packages:SpXZeigR:DisplayPanel:displaywildcard
	
	variable trn, ns
	
	switch(sv.eventCode)
		case 2:
			if ((strsearch(sv.sval,":",0)>0)||(strsearch(sv.sval," ",0)>0))
				dwc = "INVALID : or Spaces!"
				ControlUpdate/W=$k_SpXZgRMainPanelName wildcard_tb1
				trn = ticks
				do
				while((ticks-trn)<90)
				dwc=""
				SetVariable wildcard_tb1, win=$k_SpXZgRMainPanelName, activate
			endif
			break
		default:
			break
	endswitch
	ns = ItemsInList(f_SpectraList(1))
	string tstr = "Traces (" + num2str(ns) + ")"
	switch(ns)
		case 0:
			PopupMenu multitrace_tb1, win=$k_SpXZgRMainPanelName, disable=2, title=tstr
			break
		default:
			PopupMenu multitrace_tb1, win=$k_SpXZgRMainPanelName, disable=0, title=tstr
			break
	endswitch
	ControlUpdate/W=$k_SpXZgRMainPanelName multitrace_tb1

	return 0
end

// @brief creates a graph with the chosen spectra
// @return number of spectra processed
Function SpXZgR_displaySpectra()

	string theList, theOne, theXOne
	variable ic, ns, xs
	STRUCT SpXZgR_DisplayStruct sds
	SpXZgR_getPanelValues(sds)

	theList = f_SpectraList(1)
	strswitch(sds.files)
		case "All":		// fallthrough
		case "Match WildCard":	// fallthrough
			break
		default:		// specific
			theList = sds.files + ";"
			break
	endswitch
	ns = ItemsInList(theList)
	DFREF cdf = GetDataFolderDFR()
	if (cmpstr(sds.folder,"root")==0)
		SetDataFolder root:
	else
		SetDataFolder ("root:" + sds.folder)
	endif
	if (cmpstr(sds.filex,"None") != 0)
		theXOne = sds.filex
		if (sds.assp == 1)
			theList = RemoveFromList(theXOne,theList)
			ns = ItemsInList(theList)
		endif
		wave/T traceList = ListToTextWave(theList,";")
		for (ic=0;ic<ns;ic+=1)
			theOne = traceList[ic]
			strswitch(sds.multitrace)
				case "On New":
					if (ic == 0)
						display
						if (cmpstr(IgorInfo(2),"Windows")==0)
							MoveWindow k_SpXZgRMainTop, k_SpXZgRMainTop, -1, -1
						else
							MoveWindow k_SpXZgRMainTop, k_SpXZgRMainTop_Mac, -1, -1
						endif
					endif
					appendtograph $theOne vs $theXOne
					break
				case "On TopMost":
					if (ic == 0)
						DoWindow/F $(WinName(0,1))
					endif
					appendtograph $theOne vs $theXOne
					break
				default:		// each separate
					display
						if (cmpstr(IgorInfo(2),"Windows")==0)
							MoveWindow k_SpXZgRMainTop, k_SpXZgRMainTop, -1, -1
						else
							MoveWindow k_SpXZgRMainTop, k_SpXZgRMainTop_Mac, -1, -1
						endif
					appendtograph $theOne vs $theXOne
					break
			endswitch
		endfor	
	else
		wave/T traceList = ListToTextWave(theList,";")
		for (ic=0;ic<ns;ic+=1)
			theOne = traceList[ic]
			strswitch(sds.multitrace)
				case "On New":
					if (ic == 0)
						display
					endif
					appendtograph $theOne
					break
				case "On TopMost":
					if (ic == 0)
						DoWindow/F $(WinName(0,1))
					endif
					appendtograph $theOne
					break
				default:		// each separate
					display
					appendtograph $theOne
					break
			endswitch
		endfor
	endif
	SetDataFolder cdf
	return ns
end

// @brief show list of folders
Static Function/S f_FolderList()

	string dflist, xdflist

	dflist = "root;\\M1(-;"	
	xdflist = RemoveFromList("Packages",DataFolderList("*",";",root:))	
	if (ItemsInList(xdflist) != 0)
		dflist += xdflist
	endif
	
	return dflist
end

// @brief show list of spectra to display
// how = 0 main + list; how = 1 only list
Static Function/S f_SpectraList(variable how, [variable nowc])
	
	string dff = "root:"
	string dwc, flist, slist
	string theFldr = "root:"
	string excList = "w_index;"
	variable ns
	
	// set the display from folder
	ControlInfo/W=$k_SpXZgRMainPanelName flist_tb1
	if (v_value != 1)
		dff += s_value
		theFldr += s_value
	endif
	DFREF dsf = $theFldr
	if (DataFolderRefStatus(dsf) == 0)
		dff = "root:"
		dwc = ""
		theFldr = "root:"
		DFREF dsf = $theFldr
	endif
	
	// get the wave list
	slist = SortList(WaveList("*",";","DIMS:1",dsf),";",16)
	slist = RemoveFromList(excList,sList)
	ns = ItemsInList(slist)
	
	// define the main menu
	if (how == 0)
		switch(ns)
			case 0:		// no spectra in folder
				flist = "Nothing to Display;"
				break
			case 1:		// one spectrum in folder
				flist = "\\M1(All;\\M1(Match WildCard;\\M1(-;"
				break
			default:
				flist = "All;Match WildCard;\\M1(-;"
				break
		endswitch
	else
		flist = ""
	endif
	
	// define the selections for wildcards
	ControlInfo/W=$k_SpXZgRMainPanelName spectrum_tb1
	if ((v_value == 2) && ParamIsDefault(nowc))
		ControlInfo/W=$k_SpXZgRMainPanelName wildcard_tb1
		dwc = s_value
		if ((strlen(dwc) != 0))
			ControlInfo/W=$k_SpXZgRMainPanelName xnegwc_tb1
			if (v_value)
				slist = ListMatch(slist,"!"+dwc)
			else
				slist = ListMatch(slist,dwc)
			endif
		endif
	endif
	
	return (flist + slist)
end

// @brief list spectra to display as X
// @return string menu list
Static Function/S f_SpectraXList()

	string slist
	slist = "None;\\M1(-;" + f_SpectraList(1,nowc=1)
	return slist
end

// @brief list how to handle multi-trace case
// @return string menu list
Static Function/S f_MultiTraceMenu()
	
	string mtm = "\\M1(Nothing to Display;"
	variable ns
	
	ns = ItemsInList(SpXZgRMain#f_SpectraList(1))	
	if (ns == 0)
		return mtm
	endif
	
	mtm = "On New;"
	if (strlen(WinList("*",";","WIN:1"))==0)
		ControlInfo/W=$k_SpXZgRMainPanelName spectrum_tb1
		if (V_value<3)
			if (ns > 1)
				mtm += "\\M1(On TopMost;Each Separate;"
			else
				mtm += "\\M1(On TopMost;\\M1(Each Separate;"
			endif
		else
			mtm += "\\M1(On TopMost;\\M1(Each Separate;"
		endif
	else
		if (V_value<3)
			if (ns > 1)
				mtm += "On TopMost;Each Separate;"
			else
				mtm += "On TopMost;\\M1(Each Separate;"
			endif
		else
			mtm += "On TopMost;\\M1(Each Separate;"
		endif
	endif
	return mtm
end

// @brief hook for main panel window
// @return 0 no changes made, 1 changes made
Function hf_SpXZgRMainPanel(STRUCT WMWinHookStruct &hf)

	variable hR = 0
	variable nG, nS
	switch(hf.eventCode)
		case 3:	// activate
			// check if number of graphs has changed to zero
			nG = ItemsInList(WinList("*",";","WIN:1;VISIBLE:1"))
			nS = str2num(GetUserData(k_SpXZgRMainPanelName,"","nGraphs"))
			switch(nG)
				case 0:
					if (nG!=nS)
						PopupMenu multitrace_tb1, win=$k_SpXZgRMainPanelName, mode=1
						SetWindow $k_SpXZgRMainPanelName userData(nGraphs)=num2str(nG)
						hR = 1
					endif
					break
				default:
					if (nG!=nS)
						SetWindow $k_SpXZgRMainPanelName userData(nGraphs)=num2str(nG)
						hR = 1
					endif
					break
			endswitch
			break
		default:
			break
	endswitch
	return hR
end

// @brief show contextual menu INFO on panel
Static Function SpXZgR_InfoMenu()
	string cmdstr
	sprintf cmdstr, "(Version: %3.2f;About SpXZeigR;", k_SpXZgRVersion
	PopupContextualMenu cmdstr
	if (V_flag == 2)
		AboutSpXZeigR()
	endif
	return v_flag
end

// @brief show contextual menu HELP on panel
Static Function SpXZgR_HelpMenu()
	string cmdstr
	cmdstr = "Visit Web Page;Email the Developer;"
	PopupContextualMenu cmdstr
	switch(v_flag)
		case 1:	// visit Web page
			BrowseURL/Z k_SpXZgRWebPage
			break
		case 2:	// email developer
			Make/T/free/N=5 wt = "mail"
			string newline = "\r\n"
			wt[3] = "subject=" + URLEncode("SpXZeigR Package for Igor Pro")
			sprintf cmdstr, "\r==\rcompose your message above\rPROJECT VERSION: %3.2f\r%s\r",k_SpXZgRversion,ReplaceString(";",IgorInfo(3),"\r")
			wt[4] = "body=" + URLEncode(cmdstr)
			wt[1] = "Jeffrey Weimer"
			wt[2] = "uah edu"
			sprintf cmdstr, "%sto:%s%%%d%s?%s&%s" wt[0], wt[1], 40, wt[2], wt[3], wt[4]
			BrowseURL/Z ReplaceString(" ", cmdstr, ".")
			break
		default:
			break
	endswitch
	return v_flag
end

// @brief information button picture
// PNG: width= 90, height= 30
Picture SpXZgR_pInfo
	ASCII85Begin
	M,6r;%14!\!!!!.8Ou6I!!!"&!!!!?#R18/!3BT8GQ7^D&TgHDFAm*iFE_/6AH5;7DfQssEc39jTBQ
	=U#t@KS5u_NKc'hjQ<7_k>^N6#'iu's#@iL6?EN#,SR%ORqWY?g_DQ6ZakX-9m6UF`Y7B5's^*$E%B
	u3<(a:i;5<Ct\*^a)hT'K%0QC]d[0jPV;N@+9cG@fjB`p38^oR<*NngmMP4QXaLkr6j/Tp8k\$ZiA^
	F[J/@;&;!fa/0Y"8EKlO!*92tV8I!509L_n[prdb[0DD]b^77\4Qh+<X22WSL=^Tpl!>%R?bOV1l`F
	.H/kj.Q0YHO!p0Z_o!(t!"2!0>1<o&\&oX/k93#9I:/\ol*"]HFk2"&^kI,Op^Po$LJ:qE[=Zdn*%1
	/%c)$r:,4%r)#UgVCL9-4fb:)2uc00,SCF2g"FKhP:)ciSp&'<om1=hD5F)*"ddDT8%a$Z"blrKB1V
	t"bqBnEcNrlWWRU];Q?b;\6c%+`!0V&SGg^%NRV$e":,J(6+Q,'.qs8WXZ?]HQd?\@;-q_mAJ,]9,i
	ondb3ItHg(Zjc?GW[$h>t<@#!7L*gWDnag1eK/1,*>Cr1P3*D[BX`3`d.+2D9NUG(..rXX^7$1"@82
	!1KE^Ub4(b^NWMsF;Ht6&&;b$b#dun1L:o\#UFM.3gNK`n[l7Cp+c[X/cDaa?O<b.!b=-Pr2.^?1Nd
	)e2#U:Q=,SCE:&8^%*L$dX(UQj\B/Bea\(..rm00Qspp'-Bu;ci@[g2Ab(7h`\ZA=S45.(4!_jMmH)
	qUNK^MN[#3[D>08n\uMdd,!N;U*ru@<Dd(/5&X;O&;3@n7RotRD4?;%HAGk=G+fW.>tiHTqLp0W7=4
	1t\u)fWAJng`QIdQ"8TJr%$paau+6@''?G#H(RO^<AUs^^G[]\cSB@c5aI;=JigY9^3e#1T9SXPucg
	hq>mG`bOMiSe2FC2.Jjp@_T>`piIOWDnc;k%;&=gQn1M0p,[l:OIIe[!*"QkrNrEAXG*0N(r07]$fZ
	h/$5=fV3Tb,=$\psV/^EJ)4IFB]PEW'\qbg(SsMlA:JXaHWi@OR/f1s5k:MsaPoMc&J--#d&-rCGg1
	@0&:")(CjpXC94`bia)`#WJ(G?agO/a)!%!Za'1b>,JjlN'!=]&V5U;CI@Et9%o2-h+N"!1EAB5`,M
	Th&'lHW;8P&FJlPBUVCZ77C(9D;1qiXUW&&O5KD=a,V0/D%4B*&."qC)Xk?1%Zs:M/7mre"!%<ET2<
	bOD<cB%HGLYk/]p$:.Z,bn[7sj`?B9ZXXV6Rq]_Pti2gd\J3f(i:R&5_pm4KmDXm$aS/B^J!/^)#uG
	%6sfYult1cH[_1nRTfUip]H>d<$0>4r9NH8sWQ9)djkQAg3E#:]C\]o'uTN1rJBf7mE:cKPfJ<US@o
	sfC=1##U)g+pYUIm80gMI'&gcc'97IQ?8%%Ad+-[#D;.]AGGtPU1e&m.iUpnuW^=]Xm<&%d+jRgmR6
	q<!"K4)c%%V>s6.boU<k:W9@PN6o+0)@'G&kQ@q=8),*BN8CpR@_H@2O[8@=!9Ifs"n;A,h79HFe;'
	<AQ<<*SW3\4hYn'7c+!LCK<HgOtdE6\7T^B_C4`os.\g?L1-<OUon"8QFD=fRPcBo,tYs-%!5e<il-
	gK-hM%Q-;cW@=dI0o(g+V`I[7Hll^gmF1C8U`9;n:SDf?'4kXX)YA6CN6o]r]qT!s1+^3pK)B6pt_B
	a+O@`IRg8=:@XkJL"[Wg"k-TK%RqsK*5:)MTX360]U/4Wi@77;Jt3uP7<CJ.#Pn:q"VM]0-o&(8.o9
	`MEo2(5'MS@J+Rq@q<5kKI!A\?`c`\j5Xs.C`^\u^];Gr<!]0NL(T`^;0>7#+XNrGfbj/DFR`<:aKO
	an5L'f'H$C6<N=ieH_Ns:8r/-F>E>*(o2.ET1%BpgNq9:F_:'kIT8!)),C3GlcmYHU;j&0aK<:WMel
	3Ze-Om%!i`\)#_:DlKDdZeWg@P_C[O5M'iUB8>_-2HE;O1>jM;$8=V+SNHPXHb;/UA2:]pC+19D\Bd
	qtPsUXEa5qKga#B2SZ=.SRp%A!RdqL(!Ea7bt3ql@F;Uj=M08??L+[=OW75>HDQ5.GO:69br-505tC
	KaJC@jCMg**JRJQascSIH0iWNK&pUTkRi35A[F<CY2`i#$#_f\:6RcLI9_:V"&,4[]HN!OfQlP*Qtb
	VGkuA?F_!6F<)ocgU#D#V(':e98CFiHpC[p2PjB,D#;1";i6n,<g%nVGOf<>lBjHXs8BA(fD;DdgE&
	_+N0,P*1$jPnaB'W+c:JFR2daE`AbT2\$"\Atc30k=3]2,.R>E*Nf"c^j@=F?-EhKuZgDlI9;bg[c+
	#@$`/2$kB@MhsTDp>G]B0oZ#`%fgeAhHcB?i5($LInM,P9MS?gJ,auQDYK=UG;=]pX[t0`Ddn+h)@5
	*f*'#BK+[7+e+25ad[WOTm!ShS%o^pU.1GgqQgF=j%Y7Q;ZTcp"RlDZ'E)=kG_qYSr#Wb]AY@*-(nJ
	s#A#q"YFMfsgRh]Kt<,gI6=12lg#`?;TLp_*KtthTY]\gR%W:!I8"sroVaPFBo;RFjF5*7K$9'/M"a
	&=8b8<:r],W]a;6"MF%U=g2!m3l-^kmCMU]X>\[CWf<8QErql0Iq<+A?>3\a$'Y&&M_Vt+amGf@imo
	bQW3d]\44-GFK,M+U?MapjQn$rZ2MO]A366&(1N))Y5K\G-`9XF4l;%/:LK#,8h*dQfYG3mlOSIcZr
	>bLn*pC6ZP>8Kg\bG_@CKr2I%"\bg,9T7gnab8=Dm!=-WrDiH(kdbct`7o4FNN0!X<E0c>,]?+,R:L
	D]PZ0,$>?`&92Jr:c#b4?2.q.C==rdOGT-GEe&/PNlY926R6do>OS3)p0O\R3Y8&I`m-S_GCD(TPUp
	#Oh0$f?=CMoA(S7gE=*>mMVCq0YVL.YYcK,Y=`@\X=h:G[ec2^3h=YF;C/g`2VT*c?qXpKj]]U?cVq
	fC?DNujYDHgQ#<&Y/Z3l"'p#PjIED$6^p\*"iPGcpqYD$G(gq`=S8``85)IVK,7k,W='%mZ6N^%W9s
	ZH4Ib4'RZ77*WgpE7az8OZBBY!QNJ
	ASCII85End
end

// @brief help button picture
// PNG: width= 90, height= 30
Picture SpXZgR_pHelp
	ASCII85Begin
	M,6r;%14!\!!!!.8Ou6I!!!"&!!!!?#R18/!3BT8GQ7^D&TgHDFAm*iFE_/6AH5;7DfQssEc39jTBQ
	=U%&ule5u_NK]pa@g']g@U^Upt%GFQ2iG6aJpJmdFX78;,cVIC:7E<8Td:b6cN,?9UjVf\f%WZ;[/V
	%KP#JO*M&WN?THKK9cU)`=`H0[O9,)L8;-_'G*Bak\80]?@nUmHm(8j1N'qpQ@[GqTSkLm[iV;4l?5
	9p34hHca--pCc9?`a1`N@?0>MW\`C_cK87>p!!)X0(AW7k(<k1!Z6U5Zb%=PW#*`9'?8(R.l9\9B%n
	9#Xi,CY"\p?O1oCK4p_#dS:<['Ueqmu'!DdI1i5jrP3+p\-^L%B)Rl&&6R@eFq>=L[qbCBEtmmNr/L
	*e`#,Pc(S2@J/p9W2QZ)-J]W[Rki??laDuDX[@&P,(^^j"-[%#SONo\V1=G'!!%70KV'(>nd;T\r9s
	nW!!']u`J45Y;-RJO#^h#IS8@)s?-6E37K\jr"J&9mNoQd1W?So9&&7!4QcfPj`<*6p)q!4%Z!kNSb
	ab*S0C)+!-4P&qo6Jd<2$QkkZlF^m=^($s8m)tsn,tIZn\F/q!JI,[b(u%<c'JV4aX<^Bf%*k%J6&^
	>;,IqtHG)FHLBE0]KCF+J!.aqBH9Cu\K<fV!+1qo2IdrI^jN)fkTP5;J-4NXp%T0D`+g<s/YW;Xf"@
	\,T!Yqbd?E6KnN%F4r'*)'g*uD%cKYq4thknG`:Fo$Eh;$dZNZ:%ld4Hbsa^bHA79m^g0PiWdCc346
	JH/)8KM&)(k36QF'1-*7>&j)l`JADS2'.,2Z*_)fH$KMmMP'\-](',%?j1@)>F]S9TO0p.T!W[#6cg
	fTP-7;t(+Zf_JqtSn,aMH!n\';3U2ZD&S;P.=h1rnGXk<CB$fKN,kd+9PO4u%TJ&Hu4&4Crs9Y@_nH
	"MR&l)1>b[1u<1&g\hMaNi(kl1-rkL5)pKfeO6U'VM\7&0/`!A7PfqQOE]am/tCKELH9=]@#NnO'jY
	tqYGLh>IH)^mct,(P9&uXOhUj'bDC#sD;2^*qE?dh;P68RpF'`l^&V357%l%naPeh(A($.glRQtugt
	ZGl%$*W+%Ia6#,81..8g^]id,Kck$t@][$aBOjq/OasMhNuG2M,LC'G_J("Z[P4_r5QBmFntXjd',6
	lZt\G^OJI;7Rj%OX5iIM#6uCX!]FoLK`(amh5S'MpXVq/O#EQ=C>KI[/s=orf,T\.V5"J]r\=n:<P^
	dbK.Jkf0au0o*Zjc5<u!+J$%sur)3hjN3<hR:W<>kX3+#G"^cXsdL/hY`gSKQ2hQ^Pq(l!UpCdqH+(
	.;#abis6/fk6q:$aRh5_>*eM9NS:6RPelrZ>?$aa)Nf&c!V@m]6<R6e=FIgEcWdq5MWd4Wd(EGH-(t
	7'6n3kpg)VSEUsmM3$iUNPR)sTB+NfY$cV71VX=4n!'f7b&o2]5j7tq;=*jFX8d1ff/P>NYa\kIC.H
	0D<]`$GJ&fmmVZ]hoTDId<i+X\WBThm/_*d[#n'GhQY]#TjRa0oj>Y^?+^*&qn&>%qpqLF8^A1;Q1&
	-O1QL#&^mh-Vg1nFHc5Yg_^Fm5Mj%+,Mn_\Yol9dGTnRi%0.uNj'\-e(in+;$'enZ/=ITkLsojIs'f
	5J4*Sf)rJ-0)p,hFVP)c6^;1hlKdF&nZ-FC.eJ7Vk#%#29.N7pubh'DZ93h9r&DjT2'SNDUuSfXk:T
	hm!T6a,*oAQcCI[)@&bnCG;H\^W#'+J+VfO[ZNjXF'@+Pe?YI;kq8O!7WJ6/>GbW`_[MnT91E/eol'
	bTm^=u,IJJ5lD.poMum`/$SP;Lj,6doEk."\m=nfH#0X:Yfbb'MOIr-edqrknBHJ'.M!5h;8]P4A(2
	C5q?EY.TLP&:@>Ph$?Yg`,3D[$dC9?0\Lot/&E.W?j`_I5L)S`l("cMF\gETWuSY0H>CU9[07$'*X?
	.ECCH8hd=RSR5*cX/cU:_gpc,KYucE`q+RG\$$<TcCB`,F1^8,XK7BFNf9bRLZ:?J%"ljN:<;Dmlr<
	<hnCr)p-KUd:j9K#ZR[0<)\a0F9.RDN?6IID#?^a.u`5-q,0f8$Rlf7RA:d.C+<VOe$lIo%e;iX5o1
	`08MhTJ)r/NmJY-DDFd-.d!K_Rt0c0JkU#f>m(GTtJ#XKnY4Yh:U@^b&M*`#/`.YmHm=QB$'%\qX#r
	@k9m_?!'^:&'rj398\D*jgar,Hmr+Pss6/[R]X5WiKS!V5MLl\*=I@$r(oGZ,`<UmS89I+G&ERttG\
	?uGTYJ4QI94'p5&O$_NuCGa:bXG:/cc`G"U[\/_&o4D^R9qQ.&+2[(Oj,+Wf%(,h7@a%l,]TuYHJJ]
	c-7[nR\D2Y'FNK/2Is\:pn`I55s*LoL%75rm!\:SWNQ!$7lE$\oEiU0_1I2l(qmg9mW>fI686_Rj.5
	jeJn6.1(2"3)s(MJI+9@R=1DURoE!UFZS]K(#"X+#C.&IfNW]P,?eu`-]QAr!;/J\^(*&mqjc^33aT
	ho-+@KOjAb]rUUj[oC9NQ;ek29;O&*`'Q"/";k+Tg7'`6o+_GJCHppi2q`P`s):,hk.sAA13FNUdVO
	CqH6RTVp:'Y5Q5n4OSA+pK<_\dBuc<WYCcMO?Q@,LgL<7c;$W^J0;HuM+9W5^S^q4aWOpsd@r>fnk2
	So.FRL?T3's"<s%-?!6l<9^F=LQcfaIk'F`fAVN=fHg&+@:55-A/$,0Q;a!e\;h*Lf(XaXKL[!4-!c
	aqqcW-G6]?LB/PBBUY6(jb9r[dt)"0%,6E?I7ZC,@h&U9d0N'0B"I*cP&=W6+,5Q+jm*N\UX=lkGu&
	=k,OT/8_;BQ/7_Ej-C_!.H&/7RV2C0;(69I-DBB1!=ngL'RTsV0@Thl"/7EIHaEf0:a;]5Cc66VSZQ
	6I"!Xu@+C"F9t&6)h$QNJ4Z`l)J2%pja/;XcRC:V`\qo7%>:kj303LOY7gGU9[=BWi@Q<4J,J?\$`W
	[j`9>Hfs<YZk"J7Y4O9e.Z4_2'41CGG!H$J1+c^co`cG$^kE[l+]TgZQ_ZQAl-Ye&1(foL%GJNZubA
	I=\jNa+r25c`$-\_d!-SF>`c$*"bnA5Pd&@G[NL1-s#NT^QJE4K3ch;$eqe%2otU'SNkO0)Wq;?3TU
	rR^1M8Y>J.e=2WqS,EtAVsr+7Ye3:5n)T/gm&69l`j'CTj4Lg;;));SI-5M&;0PNH(V+qhEd59(q77
	:UfXZ&NG4+.BMM_c:\fMCIl=*8Wl$0*1n"*V,VrbVTeamc>-QOiL!'a[j8ho<N"<e&.<_R:uIoHWYJ
	V2XkU$7DS=[%EK"=$\$kMQ0&ZlWD`GVR/k$j8kX2:&F1\IrM\).p2mX&c?cjWb$4(kt>!Fg\$7MYDA
	UHms%/2@dgf]sf_>hK$8KIS*p\IF@UM*pf19J:qKEM*`+C1)HeU%mj[5%,n0(A&?QmTqML1]D_'#VU
	*PTY.VJl],a[1oi.[R2gCCs)EWsbZM?gV]Lt.iOP5c/>+CgY](/@X'N)9IE>TW8![nBi9rGA-g7>Hp
	7+aXH[X[R9gD:QXZ-eK.]oBqplJdKII8NiR<EiZXD*$*VkL$%p@CP!"\(botnDUa&J]RXWD/Cjs8kK
	_<Vt(nb'K\+MDAp)9hWgu3=Kl-_8`3<f3W%U'e"ljrNP(a<ThrgW8>ReE0a-h(!L0!@m!e[%Zs0JWq
	t?0?mV_+Ij[j)-=03DO_eQTRXK2hGf<1D3EY\ZChfAPHFN"fO]NbF:l!M_*b:=[),oo-29QT>^V:Jn
	:-m.rqHKcs0/5Y;,CW^2$p-3Z_&F&EBJB;>bhJ?i+bO_rAXf/4u_28sXAEi7<jcOgQrqM6=VYgP@_8
	H64h2ZJOlBs?ebm(55\!.MW!DM.KJ-<m>:brccmn<T3VCVWDrT)dYhZZGG0Gk5H\]2"fJq/]7#nTGM
	d*Rkr\k#n?2".f$$2_u>^Ei3E4V/;GBQFSYB4Z]qWhhRd8-hNf"q^:7iL-29.seIBTbbt(s41u^CK<
	qq#AJ*pLEHlLC:2KZR-9u#'FI,;"9\c,GW[%O/;p>tQ_L@Sk*gC1'^rD[Ng<&QqT8!\!;\90X=aNKD
	r`TCVbt6obG&O5$4H$sZ/XWa124<T4?Q;4T0A86rdItO<p@AD3h6a-P6iN]-!7Zr+m.(@HX1ct2t-b
	HR`A77"JcKsz8OZBBY!QNJ
	ASCII85End
end

// @brief settings button picture
// PNG: width= 90, height= 30
Picture SpXZgR_pCog
	ASCII85Begin
	M,6r;%14!\!!!!.8Ou6I!!!"&!!!!?#R18/!3BT8GQ7^D&TgHDFAm*iFE_/6AH5;7DfQssEc39jTBQ
	=U%adj95u_NKeXCo&'5*oW5;QerS2ddE(FP;'6Ql#oBiuS1dW/'TBu9uWoJd,<?@,Ku[OT_*C6>N&V
	5fgKO-Z!0m]BHZFE$kSY/b+).^UIV80KE-KEW"FQ9_,eF^bT7+UPEE3;1R;IlL+VJZGMtc/)57aYSB
	X^5kLMq7Sp9q0YBG@U214ph]9b)&eA4@(!#Ip%g0/F0_UH>\E'7M.=ui]mI6`m'G"T)B'OA[IVmQDm
	=?Eat`-Qd[5bR1c#F]`cT(Se*XgJen[DI=<Y8YF7N!d-X+iY2pq;SVDt;siWS_bs$!E]WT^pRhs]aH
	M%csq\akmJ4tMo<HGU1WqT,5cib%XrHM`>*]/&U:](RQ7QDj\u&#cMNi8>`?8;-?rCcXX>+1^gW10F
	n!h-2G-M;R\a+TD2op'?`R]"%W!DpJmO],i(@-(/F?,;L7Vkt%YOa,f\8+CV@lHVOEMgMZPnh$6>!V
	MTYBm^8f[O,?Z$2MnH6.T'JWSM4HtSissRo-):4d:ecoe5Tn^(gUEQm+o94@;L(/[91%aXk:!pP;mm
	\kh$s.7qbe%=-p1eBtDs*CHp:+$CUY\0A,jM0:4J2&pY-HWBG?nb`"BE/M-#*)+E?I*C/(r;J]APNh
	3!Ea<(u)`o?0R`ma=QV<n?GV/s3:I0Wf2_M0p@:__T%OEl+sL@10K8&ViQgR(0Q3qMLYA':/iba:,;
	]Y$@ACMV&9b[fD4A`Vq5+A!37VD0na`;0#fWNWKq#f5N>Mt)$S['[2:?=(p2$Q$$NX_cXoJ`iVOcHm
	Rb+"_b#*b4@tp)Xq9r*1_<^IVlpMJ=kE>MhiHa2]]q9<d*4(lA_8$4ej2NM5Z!#`oc=+Ttk-]%D5"O
	Yiu,o$V/I<=@2fN3Ds,PNfIEnqn6C?^[OYDs4q2k*s6TFu+@1>SKUmdko@B5>Pp)-]8`l_Ig,/1c.T
	K'Z+asa)qDc*mqZAKmijlOd;;&H$MEMWY1:\q<G#aaNVlho?TWCGL35!G658MH$RpQ,/[:S#==eP-@
	T+s%'h-7&.0)\eW6j@1gNW'FYlgRIid1g1dP0.MtL)"o@*4A+B&XU\9bRSJWg?B!keI%b6T7FS'?W(
	@7j-a-n[,Adkh%U((6"oN9G"iRV$rmb0"2lqXk08!N&V_b13Oo*tc)h=[L]E@W<ihr:]%Dbs-*cCbc
	T^`<b81D1(d_gue7JX)rMl-Q!ag!0.a4mbCL5'MQH2X<p3`1nA#69QNiWDnN[J^:kIm`JPCXo#W8lo
	?KFN_dOMp#7s\i!;q:1Vb`q^Za5j'0Sg8ALVn\tm:OM*.G/IF;=K4S+O/0U]^`u\O,i'69Y*0'f,SH
	:Kp)mH3.EQ3hDf%?f;W[LbJbR7R5Lb$8U4I7,[8ZM7fU7H5(>6BlSlr1cG6"263q!"YH.\`>aLYN(!
	e3hZYm666$Mq_c(_GHO?%CE(rnI-UV=I6M\e$%CXt$`9q"IB8d`/4e)0&Dcf`43oobf6MqdV?d>\73
	X/dI(2jZ+#[Nt'sQg5KRFl_^rEVX>cZ5h3g1gR#*IhTZf+KqmsVrW[`UcE6>MM*N0fMcT[S!:h'=ju
	EaL@5>OfU]WXd+d/JISLYCQZ_BPkB$IiAYUBq1l^ecC4a8EYJ'WJ,pak5V59k6$F23m\(d</D&W$.c
	&:n64N(\`j0%h;m7iB=j)(R^kh8BUCfn<.JP[26K1F7\>0JOc56jWCOX(6k=i$m^+A%<G5QZ.i$e8]
	01cU/k$R?&@c[1P\L>tK[OkSMmQ7lT_puI&4&#-'R99q+p;3\Sn`Ic2G%kDj/"N6oB<E0?Z6Kl"@,Y
	?4P5G,Nu\q^LTs(Vj(g3YCoZEl;W9!T)>ePG,S!10n_Y\rP(FBr90.J3;jVP^MYp<-ML6>(=)*bFsB
	&uWX-VWg'<P8G@$+\A?J1@G'F,/Z.<q/;.,=8I?;gFp>>;IjEQPE_:7`.R+3bElA@DB6<k@ksJ9lg(
	=CVM=g<G(^E#SiiFHZ8.qF-^ppkE&\[U*_);<'Lfk*Fq]^#W339=Q'IWpj"KgUWU]1,ETW<&G^OtOH
	MkGSX1r0@A!=Gd&>m2;$s(nF8b!K?8R`eZjO8V38_I$<1AcnP!)B*`T#3.X=hE[s8PMoFf*/H2@32u
	N'Len`GUk?n:K*@=9gMMi1ES9gF7flQcCD`2n^,h:`S5=GNQ^G#@^/a:?]W`PV50n4Xue>QVk8E1=]
	lWKB?uV(SiXjL_hVC,G-+W-bHd)[C`^u(BPM:VV58ltJcZ8d$CEhp-Ek)Qb.'^'f)4eT`-]7*:O[1>
	WO?>HRRZ3%&Aum4gNS.jU=.^S*B#H\'0H3Z)tG>O;)WW1_IO09[>@PI4Y3R7J0]^!UgQhj+u1-,O_#
	4q7aj2?Y5.V]ph=D*J`g8?n%JH:8P)K%MLrfVTs(X1]A:d+mFtdNBG"";'8siHNZC4&bKJq`%mNb7r
	SW;=`2-+n=L)HDOsFHoS$CX_6m<3W758iRSt7"9?7u`s%5^"&NsfV]&fKiR),nod"F>!-ZZj257RH'
	BCpkU2>pgE:BYW?=m,Fa:(R[)N0g+8U_d1?h6?87.J?1.S8QM+N.?c/5H^[K9Qq/KSe*09PFi*)kOs
	Cpa8151hB![K\`b9:/2t#`0h)TQGGW^_mOCaj@jCA@uU*q95,uIW@7!X&<O\"P/_=YGg"!\PP(fcMs
	XX8]B01I/5GVm/oHal.qLkA^e?r`*cq5<6cMYpEN]i/%/Vl(p'^fIMd8C\oHLnT1!)7oQm]mKeID*1
	Nn<=:2#ZkEe#YpHHH,[1j)T%7I4;@/)4cu_Q1)PbZM:[@i"UEI%;r>p03XoVZ_RkU=+$'7#=USG/bL
	8-+m<=>h,iqN=A8kNQ3E0-ce+TlUO7L$\:&5CW07\^Y5(=Lpj3bn5fXf]+hD?H]7Wq?&[-c"7hNK0#
	/)B'Mj<HT8ma3CurC,*bh\'aHR7Z[QbX-ZmAk800m):lpO:?P+(!;TY'R\j"AmjWGZ^'4n^bf?W3J@
	>&NBK1HqWkVhSJ@2:%U$9,hq:d,G1cCmI-TcrP\J*Ut[2@6?BcK3XN6]^DH?sm>]m;PWk0+t]M3*pb
	_i5ToaNr1&dko4ib1O7G-^#a3R58IWd+6c;6ULrU<E06&]A7B"H::^+p=jM"Cht@E-\k9W-F%RN7[f
	g9`s&hll-^kfa*7KZfMd!Yc("^(?tb@(G_h8BF>IEA!<RhTlND,!db&r!Y3m>2$M&6dHhJmnR;"(TN
	7k9deNFM:rt_%M:_\bI5MO2h<A0N#R:ZSrC"&ps\iY*%&:=-;@IrX+"G9!l_&sOI?=_'7)$hsk)[Og
	CfZ9V$@mNB]AS#G_>V6^Z_/)$iF?19\*_+U8'Lh!@O$@74\ogtP<K2K,l#,B;0e6NJ*#oS35C1Gqa?
	[/#EMYbdp\'g083t^Hm.OC']=?TCh[+\@'/CD^$lb9k>s0TnKIaqh4fI!&lDq*\4*U*,*??/2AnId;
	.P@%q^Y_gV7L#<Y@CP!Nm,EKn=&i8<r@!PTa5]H_PQ](fBqn;iMUE,Pl5E-<#!*W9G0Gifi6\]*<o4
	FnfrX,WF^_\F$1nF]^fU-bLO!=bm%5lG.k3$IWMqUu'c@l,R*B4I#7$5RGsBAo;S"q!W&r%8C2/"PK
	bsa<4<J73edT0;DW#W4)GM@uFDONL"9R+_N^([T!(k&'aJc*VLHV&^R;!(_#4Z$g7@#[rnEd4b][m6
	"s2Cf6FX#Yth+![-Bc9;DCc35!#ZOe]>R5l%A3s9r*"E3cZ^HAq!@!X3ZLR*.A7oQ8om.\p[kV)RYJ
	YS_VJ,ke(!91A):`eg`H3<A0s%C//=2RBq,pC2:S]*\P@U_Oa*3.T[g!Hf.uI$^Z574:Ig+a&Rh&b)
	g:i!IBPVCY]Y$?Mc-nM/==coe'#A=jP*M;$C2,4.LP+[KAA[:ZiG]VW6ipmf;5gRtUogbYmG#,M=Y+
	23\;kLm>:;.qMlKqn)uClJ![.i',6Vo?VRu"<5C39QHia.rIUXNcq/492/E<t4:q=5j]#0#BT^2C8R
	r=7NOaA&EGCimE'I"(o(b72sE7cRPmWBnj]tHh/;(=(Hs(iTH$*GN/REC6P4"-OQ)1Z*S9OlNXqYG,
	/qFo"%Xt5WcH)DMDo_@'gn2mp\l)\(b!Y0Pa!2n,Nj%-R@Yjn?WT$E#t(FUbj=.R08ON,:0qYL%:/M
	0]<Q1)2)G':0@s*h8ZZ<4MLPu4'A3d&SI6l9j+cCI%0ltDh?G(&13<0N\Q=?t??;p9Q8$59_n3Rli=
	5b`N"1`$#>;[JNr+$!*^fli%qGlHBaGd#r_gndbH0<a<pR0sE5L0:j)I_t)\EH/7Wqt8QJMd<r<&WK
	8J3cuoH9hij#22_bS-?/1q+bUC@(DjDc_1Dg*LCYK([C$_m"OB=44C54XF6CiRHM)#JSik-Qi#lgdX
	C:AAV;n0(-%L_0m!T,"d5MVG@HhTKZ87K.p%WH^Xh3kCpXcTY<@p]%p!H!PcGm8Ma`dWI-i:%O`.@A
	\EMhGlp>Rk7O<G2m`*r,h[u\8;4r,bUaQp%EDN*J]D4B1hFXuppq^tpModARV5%<QlNN?L%hAEkIlW
	/#`^]Bs#-d.f-97RH2#l<o@ZXZ&T?iRH-<%N9SU+'so7AAgW2mil0fWaM)A,6@)4Rp@WFC0@Y,uIN:
	5uCJkMPAJFd6VVd/UR6[rI=?0fVgq/kI,s^(YARDN54WD\PD#"bV<C5XKS<`]Fql#m@)ul]O#Nn]-2
	[lB);<HM,sPARkJs:;d4_S!/nh?qGe7@I:AsnMi7DjM_D$2XW>fsY^ZQI8$;`nm!f"mg^^mq'BNs/!
	!!!j78?7R6=>B
	ASCII85End
end